/*
 * Decompiled with CFR 0.152.
 */
package glodblock.com.github.gui;

import glodblock.com.github.handlers.HandlerOreData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.GuiScrollingList;

public class OreList
extends GuiScrollingList {
    private final HashMap<String, Integer> ores;
    private final List<String> keys;
    private final GuiScreen parent;
    private final BiConsumer<String, Boolean> onSelected;
    private boolean invert = false;
    private int selected;
    private final int mode;

    public OreList(GuiScreen parent, int width, int height, int top, int bottom, int left, int entryHeight, HashMap<String, Integer> aOres, BiConsumer<String, Boolean> onSelected, int mode) {
        super(parent.field_146297_k, width, height, top, bottom, left, entryHeight);
        this.parent = parent;
        this.onSelected = onSelected;
        this.ores = aOres;
        this.keys = new ArrayList<String>(this.ores.keySet());
        Collections.sort(this.keys);
        if (this.keys.size() > 1) {
            this.keys.add(0, "All");
        }
        this.selected = 0;
        this.mode = mode;
    }

    protected int getSize() {
        return this.keys.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selected = index;
        if (doubleClick) {
            boolean bl = this.invert = !this.invert;
        }
        if (this.onSelected != null) {
            this.onSelected.accept(this.keys.get(index), this.invert);
        }
    }

    protected boolean isSelected(int index) {
        return this.selected == index;
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        String displayString = "Unknown";
        if (Objects.equals(this.keys.get(slotIdx), "All")) {
            displayString = I18n.func_135052_a((String)"scanner.gui.all", (Object[])new Object[0]);
        } else if (this.mode == 0) {
            short id = -1;
            if (HandlerOreData.mNameToIDMap.containsKey(this.keys.get(slotIdx))) {
                id = HandlerOreData.mNameToIDMap.get(this.keys.get(slotIdx));
            }
            displayString = id == -1 ? "Unknown" : HandlerOreData.mIDToDisplayNameMap.get(id);
        } else if (this.mode == 1) {
            displayString = I18n.func_188566_a((String)("desc.immersiveengineering.info.mineral." + this.keys.get(slotIdx))) ? I18n.func_135052_a((String)("desc.immersiveengineering.info.mineral." + this.keys.get(slotIdx)), (Object[])new Object[0]) : this.keys.get(slotIdx);
        } else if (this.mode == 2) {
            Fluid fluid = FluidRegistry.getFluid((String)this.keys.get(slotIdx));
            displayString = fluid.getLocalizedName(new FluidStack(fluid, 1));
        }
        this.parent.func_73731_b(this.parent.field_146297_k.field_71466_p, this.parent.field_146297_k.field_71466_p.func_78269_a(displayString, this.listWidth - 10), this.left + 3, slotTop - 1, this.ores.getOrDefault(this.keys.get(slotIdx), 8223606).intValue());
    }
}

